% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_systematic.R
\name{estimate_systematic}
\alias{estimate_systematic}
\title{Calculate systematic effects model using LATE, ITT, or full potential outcomes.}
\usage{
estimate_systematic(
  formula,
  data,
  interaction.formula,
  control.formula = NULL,
  method = c("RI", "OLS", "2SLS"),
  na.rm = FALSE
)
}
\arguments{
\item{formula}{An object of class formula, as in lm(). For ITT estimation, specify as Y ~ Z with only the treatment variable on the right-hand side. For LATE estimation, specify as Y ~ D | Z with only the endogenous variable (D) and the instrument (Z) on the right-hand side separated by a vertical bar (|). For oracle estimation (where full potential outcome schedule is known), specify as Y(1) + Y(0) ~ Z with only the treatment variable on the right-hand side and the variables indicating the outcome under treatment and the outcome under control on the left-hand-side. The first variable on the left-hand-side will be treated as the outcome under treatment, and the second variable on the right-hand-side will be treated as the outcome under control.}

\item{data}{A data.frame, tbl_df, or data.table with the input data.}

\item{interaction.formula}{A right-sided formula with pre-treatment covariates to model treatment effects for on the right hand side, such as ~ x1 + x2 + x3.}

\item{control.formula}{A right-sided formula with pre-treatment covariates to adjust for on the right hand side, such as ~ x1 + x2 + x3. Default is NULL (no variables adjusted for). Will be ignored for LATE estimation and oracle estimation. Default is NULL}

\item{method}{RI or OLS (for ITT and oracle), RI or 2SLS (for LATE). method=OLS is shorthand for setting the empirical.Sxx variable to TRUE, nothing more.}

\item{na.rm}{A logical flag indicating whether to list-wise delete missing data. The function will report an error if missing data exist. Default is FALSE.}
}
\description{
Implements the systematic effects model proposed in Ding, Feller, and Miratrix
(2018). Can estimate an ITT or LATE model, or the actual beta in cases where
full potential outcomes schedule is available.
}
\details{
The OLS method differs from the RI method only by how the Sxx matrix is handled.
In the OLS case, seperate Sxx for treatment and control are calculated for each 
treatment arm. For RI the known Sxx based on all units is used.
}
\examples{
df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
es <- estimate_systematic( Yobs ~ Z,  interaction.formula = ~ A + B, data = df )

}
