% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_stat_calc.R
\name{SKS_stat_cov_pool}
\alias{SKS_stat_cov_pool}
\alias{SKS_stat_cov}
\title{SKS_stat_cov_pool}
\usage{
SKS_stat_cov_pool(Y, Z, X)

SKS_stat_cov(Y, Z, X)
}
\arguments{
\item{Y}{Observed outcome vector}

\item{Z}{Treatment assigment vector}

\item{X}{Additional pre-treatment covariates to adjust for in estimation, but not to interact with treatment.}
}
\value{
The value of the test.
}
\description{
SKS_stat_cov_pool is the shifted kolmogorov-smirnov statistic with covariates
to increase precision.  This is the test statistic used Ding, Feller, and
Miratrix (2016), JRSS-B.

SKS_stat_cov is the shifted kolmogorov-smirnov statistic with covariates
with model for outcomes calculated on control group only.
This avoids "splitting" the treatment variation between tx
and co groups.
We recommend this method over the "pool" method.
}
\examples{
df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
SKS_stat_cov_pool(df$Yobs, df$Z, df$A)

df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
SKS_stat_cov(df$Yobs, df$Z, df$A)

}
