% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gho_mortality.R
\name{who_mortality}
\alias{who_mortality}
\alias{get_who_mr}
\title{Use WHO Mortality Rate}
\usage{
get_who_mr(age, sex = NULL, region = NULL, year = "latest")
}
\arguments{
\item{age}{age as a continuous variable.}

\item{sex}{sex as \code{"FMLE"}-\code{"MLE"}, \code{0}-\code{1} (male = 0,
female = 1) or \code{1}-\code{2} (male = 1, female = 2).}

\item{region}{Region code.}

\item{year}{Use data from that year. Defaults to
\code{"latest"}.}
}
\value{
This function should be used within
\code{\link[=define_transition]{define_transition()}} or \code{\link[=define_parameters]{define_parameters()}}.
}
\description{
Returns age and sex-specific mortality probabilities for
a given region
}
\details{
Only locally cached data are available.
For memory space reasons
local data is only available for WHO high-income
countries (pooled), and only for the latest year.
}
\examples{

define_transition(
  C, get_who_mr(age = 50 + model_time, sex = "FMLE", region = "EUR"),
  0, 1
)

}
