% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-hai-winsorized-truncate.R
\name{step_hai_winsorized_truncate}
\alias{step_hai_winsorized_truncate}
\title{Recipes Step Winsorized Truncate Generator}
\usage{
step_hai_winsorized_truncate(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  fraction = 0.05,
  skip = FALSE,
  id = rand_id("hai_winsorized_truncate")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables that will be used to create the new variables. The
selected variables should have class \code{numeric}}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{recipes::prep()} is used.}

\item{fraction}{A positive fractional between 0 and 0.5 that is passed to the
\code{stats::quantile} paramater of \code{probs}.}

\item{skip}{A logical. Should the step be skipped when the recipe is
baked by bake.recipe()? While all operations are baked when prep.recipe()
is run, some operations may not be able to be conducted on new data
(e.g. processing the outcome variable(s)). Care should be taken when
using skip = TRUE as it may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
For \code{step_hai_winsorize_truncate}, an updated version of recipe with
the new step added to the sequence of existing steps (if any).

Main Recipe Functions:
\itemize{
\item \code{recipes::recipe()}
\item \code{recipes::prep()}
\item \code{recipes::bake()}
}
}
\description{
\code{step_hai_winsorized_truncate} creates a a \emph{specification} of a recipe
step that will winsorize numeric data.
}
\details{
\strong{Numeric Variables}
Unlike other steps, \code{step_hai_winsorize_truncate} does \emph{not}
remove the original numeric variables. \code{\link[recipes:step_rm]{recipes::step_rm()}} can be
used for this purpose.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))

len_out <- 10
by_unit <- "month"
start_date <- as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a = rnorm(len_out),
  b = runif(len_out)
)

# Create a recipe object
rec_obj <- recipe(b ~ ., data = data_tbl) \%>\%
  step_hai_winsorized_truncate(a, fraction = 0.05)

# View the recipe object
rec_obj

# Prepare the recipe object
prep(rec_obj)

# Bake the recipe object - Adds the Time Series Signature
bake(prep(rec_obj), data_tbl)

rec_obj \%>\% get_juiced_data()

}
\seealso{
Other Recipes: 
\code{\link{step_hai_fourier}()},
\code{\link{step_hai_fourier_discrete}()},
\code{\link{step_hai_hyperbolic}()},
\code{\link{step_hai_scale_zero_one}()},
\code{\link{step_hai_scale_zscore}()},
\code{\link{step_hai_winsorized_move}()}
}
\concept{Recipes}
