% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-hai-get-density-data.R
\name{hai_get_density_data_tbl}
\alias{hai_get_density_data_tbl}
\title{Get Density Data Helper}
\usage{
hai_get_density_data_tbl(.data, .unnest = TRUE, .group_data = TRUE)
}
\arguments{
\item{.data}{The data from the \code{hai_distribution_comparison_tbl()} function
as this function looks for an attribute of \code{hai_dist_compare_tbl}}

\item{.unnest}{Should the resulting tibble be un-nested, a Boolean value TRUE/FALSE.
The default is TRUE}

\item{.group_data}{Should the resulting tibble be grouped, a Boolean value TRUE/FALSE.
The default is FALSE}
}
\value{
A tibble.
}
\description{
This function will return a tibble that can either be nested/unnested,
and grouped or un-grouped. The \code{.data} argument must be the output of the
\code{hai_distribution_comparison_tbl()} function.
}
\details{
This function expects to take the output of the \code{hai_distribution_comparison_tbl()}
function. It returns a tibble of the \code{tidy} density data.
}
\examples{
library(dplyr)

df <- hai_scale_zero_one_vec(.x = mtcars$mpg) \%>\%
  hai_distribution_comparison_tbl()
hai_get_density_data_tbl(df)

}
\seealso{
Other Distribution Functions: 
\code{\link{hai_distribution_comparison_tbl}()},
\code{\link{hai_get_dist_data_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Distribution Functions}
