% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinan.R
\name{sinan_diseases}
\alias{sinan_diseases}
\title{List Available SINAN Diseases}
\usage{
sinan_diseases(search = NULL)
}
\arguments{
\item{search}{Character. Optional search term to filter diseases by
code, name, or description. Case-insensitive and accent-insensitive.}
}
\value{
A tibble with columns: code, name, description.
}
\description{
Returns a tibble with all notifiable diseases (agravos) available in SINAN,
including codes, names, and descriptions.
}
\examples{
sinan_diseases()
sinan_diseases(search = "dengue")
sinan_diseases(search = "sifilis")
}
\seealso{
Other sinan: 
\code{\link{sinan_cache_status}()},
\code{\link{sinan_clear_cache}()},
\code{\link{sinan_data}()},
\code{\link{sinan_dictionary}()},
\code{\link{sinan_info}()},
\code{\link{sinan_variables}()},
\code{\link{sinan_years}()}
}
\concept{sinan}
