% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns.R
\name{pns_sidra_data}
\alias{pns_sidra_data}
\title{Get PNS tabulated data from SIDRA API}
\usage{
pns_sidra_data(
  table,
  territorial_level = "brazil",
  geo_code = "all",
  year = NULL,
  variable = NULL,
  classifications = NULL,
  raw = FALSE
)
}
\arguments{
\item{table}{Numeric or character. SIDRA table code.
Use \code{pns_sidra_tables()} or \code{pns_sidra_search()} to find codes.}

\item{territorial_level}{Character. Geographic level:
"brazil" (N1), "region" (N2), "state" (N3), "municipality" (N6).
Default "brazil".}

\item{geo_code}{Character. IBGE code(s) for specific localities.
"all" returns all localities at the chosen level. Default "all".}

\item{year}{Numeric. Year(s) to query. NULL returns all available periods.}

\item{variable}{Numeric or character. SIDRA variable ID(s).
NULL returns all variables excluding metadata. Default NULL.}

\item{classifications}{Named list. SIDRA classification filters.
Example: list("2" = "6794") for sex = total.
NULL returns default aggregation. Default NULL.}

\item{raw}{Logical. If TRUE, returns raw API output without cleaning.
Default FALSE.}
}
\value{
A tibble with queried indicators.
}
\description{
Queries the IBGE SIDRA API to retrieve tabulated PNS indicators.
Returns pre-aggregated data (prevalences, means, proportions) with
confidence intervals and coefficients of variation.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# self-rated health by state, 2019
pns_sidra_data(
  table = 4751,
  territorial_level = "state",
  year = 2019
)

# same table, Brazil-level, both years
pns_sidra_data(
  table = 4751,
  territorial_level = "brazil",
  year = c(2013, 2019)
)

# hypertension data
pns_sidra_data(
  table = 4416,
  territorial_level = "brazil"
)
\dontshow{\}) # examplesIf}
}
