% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnadc.R
\name{pnadc_variables}
\alias{pnadc_variables}
\title{List PNADC variables}
\usage{
pnadc_variables(module, year = NULL, cache_dir = NULL, refresh = FALSE)
}
\arguments{
\item{module}{Character. The module identifier (e.g., "deficiencia", "habitacao").}

\item{year}{Numeric. Year to get variables for. Uses most recent year if NULL.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
A character vector of variable names.
}
\description{
Returns a list of available variables in the PNADC microdata for a given module.
This is a convenience wrapper around \code{\link{pnadc_dictionaries}}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# list variables for deficiencia module
pnadc_variables(module = "deficiencia", cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
