% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnadc.R
\name{pnadc_dictionaries}
\alias{pnadc_dictionaries}
\title{Download PNADC variable dictionary}
\usage{
pnadc_dictionaries(module, year = NULL, cache_dir = NULL, refresh = FALSE)
}
\arguments{
\item{module}{Character. The module identifier (e.g., "deficiencia", "habitacao").}

\item{year}{Numeric. Year to get dictionary for. Uses most recent year if NULL.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
A tibble with variable definitions.
}
\description{
Downloads and returns the variable dictionary for PNADC microdata.
The dictionary is cached locally to avoid repeated downloads.
}
\details{
The dictionary includes variable names, positions, and widths from the
IBGE input specification file. This is useful for understanding the structure
of the data returned by \code{\link{pnadc_data}}.
}
\section{Data source}{

Dictionaries are downloaded from the IBGE FTP server.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# get dictionary for deficiencia module
dict <- pnadc_dictionaries(module = "deficiencia", cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
