% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.lambda_0.given.Delta.R
\name{find.lambda_0.given.Delta}
\alias{find.lambda_0.given.Delta}
\title{Function to solve for the baseline recurrent event rate given a mean frequency difference for one-sample simulations.}
\usage{
find.lambda_0.given.Delta(
  lambda_star,
  null.lambda_0,
  gamma_shape,
  gamma_scale,
  Delta,
  t
)
}
\arguments{
\item{lambda_star}{Rate parameter of an exponential distribution in generating the terminal event.}

\item{null.lambda_0}{Baseline recurrent event rate under the null hypothesis.}

\item{gamma_shape}{Shape parameter of the Gamma frailty distribution.}

\item{gamma_scale}{Scale parameter of the Gamma frailty distribution.}

\item{Delta}{Target difference in the mean frequency function at time \code{t} between the null and alternative.}

\item{t}{Event time (time since enrollment) at which the mean frequency difference is defined.}
}
\value{
A numeric value giving the baseline recurrent event rate \eqn{\lambda_0} that satisfies the specified mean
frequency difference at time \code{t}.
}
\description{
Computes the value of the baseline recurrent event rate parameter \eqn{\lambda_0} hat yields a specified difference in mean
frequency function at a given event time, relative to a null value.
}
\examples{
# Toy Example: n = 800, two interim analysi planned
# at 50\% and 75\% if maximum information, along with
# a final analysis at 100\% maximum information.
# Assuming the maximum information is 100,
# overall Type I error at 0.05 and power at 0.8.
find.Delta.given.power(K = 3, timing = c(0.5, 0.75, 1),
alpha = 0.05, power = 0.8, Imax = 100)
# Use the computed value from the
# "find.Delta.given.power()" function
find.lambda_0.given.Delta(lambda_star = 0.1, null.lambda_0 = 1.15,
gamma_shape = 2, gamma_scale = 0.5, Delta = 0.2834591, t = 2)

}
