% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/True.mu.R
\name{True.mu}
\alias{True.mu}
\title{Function to calculate the true value of the mean frequency function.}
\usage{
True.mu(data, t)
}
\arguments{
\item{data}{A data frame generated by \code{Onesample.generate.sequential()} (optionally after applying \code{Apply.calendar.censoring()})
containing composite endpoint data in long format. Each subject may contribute multiple rows corresponding to recurrent events,
terminal event, or censoring.}

\item{t}{A numeric vector specifying event times (time since enrollment) at which the true value of the mean frequency is evaluated.}
}
\value{
A numeric vector giving the true mean frequency evaluated at \code{t}.
}
\description{
Computes the theoretical mean frequency function for the composite endpoint under the assumed data-generating mechanisim.
The calculation uses the parameters stored in the simulated data.
}
\examples{
df <- Onesample.generate.sequential(size = 200, recruitment = 3, calendar = 5,
random.censor.rate = 0.05, seed = 1123)
True.mu(data = df, t = c(1.5, 2.9, 4.6))
}
\references{
Mao L, Lin DY. Semiparametric regression for the weighted composite endpoint of recurrent and terminal events. \emph{Biostatistics}. 2016 Apr; \strong{17(2)} :390-403.
}
