% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{Ki67}
\alias{Ki67}
\title{Ki67 Data}
\format{
\describe{
\item{\code{patientID}}{\link[base]{factor}, unique patient identifier}
\item{\code{tissueID}}{\link[base]{factor}, TMA core identifier}
\item{\code{recurrence}}{\link[base]{integer}, recurrence indicator, 1 = Recurred, 0 = not Recurred}
\item{\code{recfreesurv_mon}}{\link[base]{integer}, recurrence-free survival time in months}
\item{\code{logKi67}}{\link[base]{double}, log-transformed cell signal intensity of the protein immunofloerscence signal}
\item{\code{age}}{\link[base]{integer}, age at diagnosis}
\item{\code{Tstage}}{\link[base]{integer}, tumor stage}
\item{\code{node}}{\link[base]{factor}, node stage}
\item{\code{HR}}{\link[base]{logical}, hormone positive status}
\item{\code{histology}}{\link[base]{integer}, histology grade}
\item{\code{Her2}}{\link[base]{logical}, Her2 status}
\item{\code{race}}{\link[base]{character}, race, White, Black, Asian, Native Hawaiian or Other Pacific Islander, American Indian or Alaska Native, Unknown}
\item{\code{adj_chemo}}{\link[base]{logical}, whether completed adjuvant chemo treatment}
\item{\code{adj_rad}}{\link[base]{integer}, adjuvant radiation treatment, 0 = unknown,  1 = done, 2 = NOT done}
}
}
\usage{
Ki67
}
\description{
Ki67 cell data containing 622 patients.
}
\details{
The \link{groupedHyperframe} \code{Ki67} is the complete data, to be used in examples of downstream packages
\pkg{maxEff} and \pkg{hyper.gam}.
}
\keyword{internal}
