% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{plot.gmnl}
\alias{plot.gmnl}
\title{Plot of the Distribution of the Conditional Expectation of Random Parameters}
\usage{
\method{plot}{gmnl}(
  x,
  par = NULL,
  effect = c("ce", "wtp"),
  wrt = NULL,
  type = c("density", "histogram"),
  adjust = 1,
  main = NULL,
  col = "indianred1",
  breaks = 10,
  ylab = NULL,
  xlab = NULL,
  ind = FALSE,
  id = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{gmnl}.}

\item{par}{a string giving the name of the variable with random parameter.}

\item{effect}{a string indicating whether the conditional expectation, "\code{ce}", or the WTP, "\code{wtp}" should be plotted.}

\item{wrt}{a string indicating with respect to which variable the WTP should be computed if \code{effect = "wtp"}.}

\item{type}{a string indicating the type of distribution: it can be a \code{histogram} or a \code{density} of the conditional expectation of the random coefficients or WTP.}

\item{adjust}{bandwidth for the kernel density.}

\item{main}{an overall title for the plot.}

\item{col}{color for the graph.}

\item{breaks}{number of breaks for the histrogram if \code{type = "histogram"}.}

\item{ylab}{a title for the y axis.}

\item{xlab}{a title for the x axis.}

\item{ind}{a boolean. If \code{TRUE}, a 95\% interval of conditional distribution for each individual is plotted. As default, the conditional expectation of \code{par} for the first 10 individual is plotted.}

\item{id}{only relevant if \code{ind} is not \code{NULL}. This is a vector indicating the individuals for whom the user want to plot the conditional coefficients.}

\item{...}{further arguments to be passed to \code{plot} or \code{plotCI}.}
}
\description{
Methods for \code{gmnl} objects which provide a plot of the distribution of the conditional expectation of the random parameters or the distribution of the conditional willigness-to-pay.
}
\examples{
\dontrun{
## Examples using the Electricity data set from the mlogit package
library(mlogit)
data("Electricity", package = "mlogit")
Electr <- mlogit.data(Electricity, id.var = "id", choice = "choice",
                     varying = 3:26, shape = "wide", sep = "")
                     
## Estimate a MIXL model with correlated random parameters
Elec.cor <- gmnl(choice ~ pf + cl + loc + wk + tod + seas| 0, data = Electr,
                 subset = 1:3000,
                 model = 'mixl',
                 R = 10,
                 panel = TRUE,
                 ranp = c(cl = "n", loc = "n", wk = "n", tod = "n", seas = "n"),
                 correlation = TRUE)
                 
## Plot the density of the conditional expectation distribution of loc
plot(Elec.cor, par = "loc", effect = "ce", type = "density", col = "grey")

## Plot the conditional expectation of loc for each individual
plot(Elec.cor, par = "loc", effect = "ce", ind = TRUE, id = 1:30)

## Plot the WTP for cl
plot(Elec.cor, par = "loc", effect = "wtp", wrt = "pf")                  
} 
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge University Press.
}
}
\seealso{
\code{\link[gmnl]{gmnl}} for the estimation of different multinomial models with individual heterogeneity and \code{\link[gmnl]{effect.gmnl}}.
}
\author{
Mauricio Sarrias
}
