% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.R
\name{BIC}
\alias{BIC}
\alias{BIC.gmm}
\alias{BIC.gmbn}
\alias{BIC.gmdbn}
\title{Compute the Bayesian Information Criterion (BIC) of a Gaussian mixture model
or graphical model}
\usage{
\method{BIC}{gmm}(object, data, y = NULL, regul = 0.01, ...)

\method{BIC}{gmbn}(object, data, col_seq = NULL, ...)

\method{BIC}{gmdbn}(object, data, col_seq = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{gmm}, \code{gmbn} or \code{gmdbn}.}

\item{data}{A data frame containing the data used to compute the BIC. Its
columns must explicitly be named after the variables (or nodes) of
\code{object}. If \code{object} is a \code{gmm} object, a numeric matrix can
be passed.}

\item{y}{A character vector containing the dependent variables if a
conditional BIC is computed. If \code{NULL} (the default), the joint BIC is
computed.}

\item{regul}{A positive numeric value corresponding to the regularization
constant if a penalty term is added for Bayesian regularization. If
\code{NULL}, no penalty term is added. If a conditional BIC is computed, this
argument is ignored.}

\item{\dots}{Unused arguments from the generic function.}

\item{col_seq}{A character vector containing the column names of \code{data}
that describe the observation sequence. If \code{NULL} (the default), all the
observations belong to a single sequence. If \code{object} is a temporal
\code{gmbn} or \code{gmdbn} object, the observations of a same sequence must
be ordered such that the \eqn{t}th one is related to time slice \eqn{t}
(note that the sequences can have different lengths). If \code{object} is a
non-temporal \code{gmbn} object, this argument is ignored.}
}
\value{
If \code{object} is a \code{gmm} object, a numeric value
corresponding to the BIC.

If \code{object} is a \code{gmbn} or \code{gmdbn} object, a list with
elements:
\item{global}{A numeric value corresponding to the global BIC.}
\item{local}{For a \code{gmbn} object, a numeric vector containing the local
conditional BICs. For a \code{gmdbn} object, a list of numeric vectors
containing these values for each \code{gmbn} element.}
}
\description{
This function computes the Bayesian Information Criterion (BIC) of a Gaussian
mixture model or graphical model:
\deqn{BIC = logLik - \frac{\log(n_{obs})}{2} n_{par}}
where \eqn{logLik} is the log-likelihood, \eqn{n_{obs}} the number of
observations in the data and \eqn{n_{par}} the number of free parameters.
}
\examples{
data(gmm_body, data_body)
bic_1 <- BIC(gmm_body, data_body)
bic_2 <- BIC(gmm_body, data_body, y = "WAIST")

data(gmbn_body, data_body)
bic_3 <- BIC(gmbn_body, data_body)

data(gmdbn_air, data_air)
bic_4 <- BIC(gmdbn_air, data_air, col_seq = "DATE")

}
\seealso{
\code{\link{AIC}}, \code{\link{logLik}}
}
