# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

.dbeta_cpp <- function(x, gamma, delta, log_prob = FALSE) {
    .Call(`_gkwdist_dbeta_`, x, gamma, delta, log_prob)
}

.pbeta_cpp <- function(q, gamma, delta, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pbeta_`, q, gamma, delta, lower_tail, log_p)
}

.qbeta_cpp <- function(p, gamma, delta, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qbeta_`, p, gamma, delta, lower_tail, log_p)
}

.rbeta_cpp <- function(n, gamma, delta) {
    .Call(`_gkwdist_rbeta_`, n, gamma, delta)
}

.llbeta_cpp <- function(par, data) {
    .Call(`_gkwdist_llbeta`, par, data)
}

.grbeta_cpp <- function(par, data) {
    .Call(`_gkwdist_grbeta`, par, data)
}

.hsbeta_cpp <- function(par, data) {
    .Call(`_gkwdist_hsbeta`, par, data)
}

.dbkw_cpp <- function(x, alpha, beta, gamma, delta, log_prob = FALSE) {
    .Call(`_gkwdist_dbkw`, x, alpha, beta, gamma, delta, log_prob)
}

.pbkw_cpp <- function(q, alpha, beta, gamma, delta, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pbkw`, q, alpha, beta, gamma, delta, lower_tail, log_p)
}

.qbkw_cpp <- function(p, alpha, beta, gamma, delta, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qbkw`, p, alpha, beta, gamma, delta, lower_tail, log_p)
}

.rbkw_cpp <- function(n, alpha, beta, gamma, delta) {
    .Call(`_gkwdist_rbkw`, n, alpha, beta, gamma, delta)
}

.llbkw_cpp <- function(par, data) {
    .Call(`_gkwdist_llbkw`, par, data)
}

.grbkw_cpp <- function(par, data) {
    .Call(`_gkwdist_grbkw`, par, data)
}

.hsbkw_cpp <- function(par, data) {
    .Call(`_gkwdist_hsbkw`, par, data)
}

.dmc_cpp <- function(x, gamma, delta, lambda, log_prob = FALSE) {
    .Call(`_gkwdist_dmc`, x, gamma, delta, lambda, log_prob)
}

.pmc_cpp <- function(q, gamma, delta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pmc`, q, gamma, delta, lambda, lower_tail, log_p)
}

.qmc_cpp <- function(p, gamma, delta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qmc`, p, gamma, delta, lambda, lower_tail, log_p)
}

.rmc_cpp <- function(n, gamma, delta, lambda) {
    .Call(`_gkwdist_rmc`, n, gamma, delta, lambda)
}

.llmc_cpp <- function(par, data) {
    .Call(`_gkwdist_llmc`, par, data)
}

.grmc_cpp <- function(par, data) {
    .Call(`_gkwdist_grmc`, par, data)
}

.hsmc_cpp <- function(par, data) {
    .Call(`_gkwdist_hsmc`, par, data)
}

.dekw_cpp <- function(x, alpha, beta, lambda, log_prob = FALSE) {
    .Call(`_gkwdist_dekw`, x, alpha, beta, lambda, log_prob)
}

.pekw_cpp <- function(q, alpha, beta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pekw`, q, alpha, beta, lambda, lower_tail, log_p)
}

.qekw_cpp <- function(p, alpha, beta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qekw`, p, alpha, beta, lambda, lower_tail, log_p)
}

.rekw_cpp <- function(n, alpha, beta, lambda) {
    .Call(`_gkwdist_rekw`, n, alpha, beta, lambda)
}

.llekw_cpp <- function(par, data) {
    .Call(`_gkwdist_llekw`, par, data)
}

.grekw_cpp <- function(par, data) {
    .Call(`_gkwdist_grekw`, par, data)
}

.hsekw_cpp <- function(par, data) {
    .Call(`_gkwdist_hsekw`, par, data)
}

.dgkw_cpp <- function(x, alpha, beta, gamma, delta, lambda, log_prob = FALSE) {
    .Call(`_gkwdist_dgkw`, x, alpha, beta, gamma, delta, lambda, log_prob)
}

.pgkw_cpp <- function(q, alpha, beta, gamma, delta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pgkw`, q, alpha, beta, gamma, delta, lambda, lower_tail, log_p)
}

.qgkw_cpp <- function(p, alpha, beta, gamma, delta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qgkw`, p, alpha, beta, gamma, delta, lambda, lower_tail, log_p)
}

.rgkw_cpp <- function(n, alpha, beta, gamma, delta, lambda) {
    .Call(`_gkwdist_rgkw`, n, alpha, beta, gamma, delta, lambda)
}

.llgkw_cpp <- function(par, data) {
    .Call(`_gkwdist_llgkw`, par, data)
}

.grgkw_cpp <- function(par, data) {
    .Call(`_gkwdist_grgkw`, par, data)
}

.hsgkw_cpp <- function(par, data) {
    .Call(`_gkwdist_hsgkw`, par, data)
}

#' @title Estimate Distribution Parameters Using Method of Moments
#'
#' @description
#' Estimates parameters for various distribution families from the Generalized Kumaraswamy
#' family using the method of moments. The implementation is optimized for numerical
#' stability and computational efficiency through Nelder-Mead optimization and adaptive
#' numerical integration.
#'
#' @param x Numeric vector of observations. All values must be in the open interval (0,1).
#'   Values outside this range will be automatically truncated to avoid numerical issues.
#' @param family Character string specifying the distribution family. Valid options are:
#'   \code{"gkw"} (Generalized Kumaraswamy - 5 parameters),
#'   \code{"bkw"} (Beta-Kumaraswamy - 4 parameters),
#'   \code{"kkw"} (Kumaraswamy-Kumaraswamy - 4 parameters),
#'   \code{"ekw"} (Exponentiated Kumaraswamy - 3 parameters),
#'   \code{"mc"} (McDonald - 3 parameters),
#'   \code{"kw"} (Kumaraswamy - 2 parameters),
#'   \code{"beta"} (Beta - 2 parameters).
#'   The string is case-insensitive. Default is \code{"gkw"}.
#' @param n_starts Integer specifying the number of different initial parameter values
#'   to try during optimization. More starting points increase the probability of finding
#'   the global optimum at the cost of longer computation time. Default is 5.
#'
#' @return Named numeric vector containing the estimated parameters for the specified
#'   distribution family. Parameter names correspond to the distribution specification.
#'   If estimation fails, returns a vector of NA values with appropriate parameter names.
#'
#' @details
#' The function uses the method of moments to estimate distribution parameters by minimizing
#' the weighted sum of squared relative errors between theoretical and sample moments
#' (orders 1 through 5). The optimization employs the Nelder-Mead simplex algorithm,
#' which is derivative-free and particularly robust for this problem.
#'
#' Key implementation features: logarithmic calculations for numerical stability,
#' adaptive numerical integration using Simpson's rule with fallback to trapezoidal rule,
#' multiple random starting points to avoid local minima, decreasing weights for
#' higher-order moments (1.0, 0.8, 0.6, 0.4, 0.2), and automatic parameter constraint
#' enforcement.
#'
#' Parameter Constraints:
#' All parameters are constrained to positive values. Additionally, family-specific
#' constraints are enforced: alpha and beta in (0.1, 50.0), gamma in (0.1, 10.0) for
#' GKw-related families or (0.1, 50.0) for Beta, delta in (0.01, 10.0), and lambda in
#' (0.1, 20.0).
#'
#' The function will issue warnings for empty input vectors, sample sizes less than 10
#' (unreliable estimation), or failure to find valid parameter estimates (returns defaults).
#'
#' @examples
#' \donttest{
#' # Generate sample data from Beta distribution
#' set.seed(123)
#' x <- rbeta(100, shape1 = 2, shape2 = 3)
#'
#' # Estimate Beta parameters
#' params_beta <- gkwgetstartvalues(x, family = "beta")
#' print(params_beta)
#'
#' # Estimate Kumaraswamy parameters
#' params_kw <- gkwgetstartvalues(x, family = "kw")
#' print(params_kw)
#'
#' # Estimate GKw parameters with more starting points
#' params_gkw <- gkwgetstartvalues(x, family = "gkw", n_starts = 10)
#' print(params_gkw)
#' }
#'
#' @references
#' Jones, M. C. (2009). Kumaraswamy's distribution: A beta-type distribution with
#' some tractability advantages. Statistical Methodology, 6(1), 70-81.
#'
#' @export
gkwgetstartvalues <- function(x, family = "gkw", n_starts = 5L) {
    .Call(`_gkwdist_gkwgetstartvalues`, x, family, n_starts)
}

.dkkw_cpp <- function(x, alpha, beta, delta, lambda, log_prob = FALSE) {
    .Call(`_gkwdist_dkkw`, x, alpha, beta, delta, lambda, log_prob)
}

.pkkw_cpp <- function(q, alpha, beta, delta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pkkw`, q, alpha, beta, delta, lambda, lower_tail, log_p)
}

.qkkw_cpp <- function(p, alpha, beta, delta, lambda, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qkkw`, p, alpha, beta, delta, lambda, lower_tail, log_p)
}

.rkkw_cpp <- function(n, alpha, beta, delta, lambda) {
    .Call(`_gkwdist_rkkw`, n, alpha, beta, delta, lambda)
}

.llkkw_cpp <- function(par, data) {
    .Call(`_gkwdist_llkkw`, par, data)
}

.grkkw_cpp <- function(par, data) {
    .Call(`_gkwdist_grkkw`, par, data)
}

.hskkw_cpp <- function(par, data) {
    .Call(`_gkwdist_hskkw`, par, data)
}

.dkw_cpp <- function(x, alpha, beta, log_prob = FALSE) {
    .Call(`_gkwdist_dkw`, x, alpha, beta, log_prob)
}

.pkw_cpp <- function(q, alpha, beta, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_pkw`, q, alpha, beta, lower_tail, log_p)
}

.qkw_cpp <- function(p, alpha, beta, lower_tail = TRUE, log_p = FALSE) {
    .Call(`_gkwdist_qkw`, p, alpha, beta, lower_tail, log_p)
}

.rkw_cpp <- function(n, alpha, beta) {
    .Call(`_gkwdist_rkw`, n, alpha, beta)
}

.llkw_cpp <- function(par, data) {
    .Call(`_gkwdist_llkw`, par, data)
}

.grkw_cpp <- function(par, data) {
    .Call(`_gkwdist_grkw`, par, data)
}

.hskw_cpp <- function(par, data) {
    .Call(`_gkwdist_hskw`, par, data)
}

