% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.permustats.R
\name{fortify.permustats}
\alias{fortify.permustats}
\alias{tidy.permustats}
\title{Fortify permutation statistics}
\usage{
\method{fortify}{permustats}(model, data, scale = FALSE, ...)

\method{tidy}{permustats}(x, data, scale = FALSE, ...)
}
\arguments{
\item{model, x}{an object of created by \code{\link[vegan:permustats]{vegan::permustats()}}.}

\item{data}{original data set. Currently ignored.}

\item{scale}{logical; return standardized effect sizes (SES)?}

\item{...}{Other parameters passed to functions (ignored).}
}
\value{
A tibble with columns \code{permutations}, and \code{terms} containing the
values of tests statistics under the null hypothesis, and a factor
labelling the permutation, respectively.
}
\description{
Fortify permutation statistics
}
\examples{
library("vegan")
data(dune, dune.env, package = "vegan")
mod <- adonis2(dune ~ Management + A1, data = dune.env)
## use permustats
perm <- permustats(mod)
}
