% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.envfit.R
\name{autoplot.envfit}
\alias{autoplot.envfit}
\title{ggplot-based plot for \code{envfit} objects}
\usage{
\method{autoplot}{envfit}(
  object,
  geom = c("label", "text", "label_repel", "text_repel"),
  line.col = "black",
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"envfit"}, the result of a call to
\code{\link[vegan:envfit]{vegan::envfit()}}.}

\item{geom}{character; which geom to use to label vectors and factor
centroids.}

\item{line.col}{colour with which to draw vectors.}

\item{xlab}{character; label for the x-axis.}

\item{ylab}{character; label for the y-axis.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{...}{additional arguments passed to \code{\link[ggplot2:fortify]{ggplot2::fortify()}}.}
}
\value{
A ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:envfit]{vegan::envfit()}}.
}
\examples{

library("vegan")
data(varespec, varechem)
ord1 <- metaMDS(varespec)
fit1 <- envfit(ord1, varechem, perm = 199)

autoplot(fit1, geom = 'label_repel')

data(dune, dune.env)
ord2 <- cca(dune)
fit2 <- envfit(ord2 ~ Moisture + A1, dune.env, perm = 199)

autoplot(fit2)
}
\author{
Gavin L. Simpson
}
