% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcharts.R
\name{ggbarweight}
\alias{ggbarweight}
\title{Weighted Univariate Bar Charts}
\usage{
ggbarweight(df, x, weights, fill = NULL)
}
\arguments{
\item{df}{data frame of survey}

\item{x}{name of question of interest}

\item{weights}{survey weights that sums to sample size}

\item{fill}{if true the fill of each bar will be a different color corresponding to the level of the factor}
}
\value{
ggplot object
}
\description{
In ggsurvey you specify both the plotting variables and weights in plain text with no quotes.
}
\examples{
library(survey)
#Example with data frame
data(api)
ggbarweight(apistrat, stype, pw)
ggbarweight(apistrat, stype, pw, fill = TRUE)
data(nhanes)
ggbarweight(nhanes, race, WTMEC2YR)+ylab("Proportion")
}
