% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_daa.R
\name{calculate_abundance_stats}
\alias{calculate_abundance_stats}
\title{Helper function to calculate abundance statistics for differential analysis}
\usage{
calculate_abundance_stats(abundance, metadata, group, features, group1, group2)
}
\arguments{
\item{abundance}{A matrix or data frame with features as rows and samples as columns}

\item{metadata}{A data frame containing sample information}

\item{group}{Character string specifying the group column name in metadata}

\item{features}{Character vector of feature names to calculate statistics for}

\item{group1}{Character string specifying the first group name}

\item{group2}{Character string specifying the second group name}
}
\value{
A data frame with columns:
  \item{feature}{Feature identifier}
  \item{mean_rel_abundance_group1}{Mean relative abundance for group1}
  \item{sd_rel_abundance_group1}{Standard deviation of relative abundance for group1}
  \item{mean_rel_abundance_group2}{Mean relative abundance for group2}
  \item{sd_rel_abundance_group2}{Standard deviation of relative abundance for group2}
  \item{log2_fold_change}{Log2 fold change (group2/group1)}
}
\description{
This function calculates mean relative abundance, standard deviation, and log2 fold change
for each feature between two groups.
}
\keyword{internal}
