% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_hardswish}
\alias{ggml_hardswish}
\title{Hard Swish Activation (Graph)}
\usage{
ggml_hardswish(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the Hard Swish operation
}
\description{
Creates a graph node for Hard Swish activation.
HardSwish(x) = x * ReLU6(x + 3) / 6 = x * min(max(0, x + 3), 6) / 6.
Used in MobileNetV3 and other efficient architectures.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-4, -1, 0, 1, 4))
r <- ggml_hardswish(ctx, a)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)
ggml_free(ctx)
}
}
