% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_group_norm}
\alias{ggml_group_norm}
\title{Group Normalization (Graph)}
\usage{
ggml_group_norm(ctx, a, n_groups, eps = 1e-05)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{n_groups}{Number of groups to divide channels into}

\item{eps}{Epsilon for numerical stability (default 1e-5)}
}
\value{
Tensor representing the group norm operation
}
\description{
Creates a graph node for group normalization.
Normalizes along ne0*ne1*n_groups dimensions.
Used in Stable Diffusion and other image generation models.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# 4 channels, 2 groups (2 channels per group)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 8)
ggml_set_f32(a, rnorm(32))
result <- ggml_group_norm(ctx, a, n_groups = 2)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
