% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_flux.R
\name{plot_flux}
\alias{plot_flux}
\title{Plot the influx and outflux of a multivariate missing data pattern}
\usage{
plot_flux(data, vrb = "all", label = TRUE, caption = TRUE)
}
\arguments{
\item{data}{An incomplete dataset of class \code{data.frame} or \code{matrix}.}

\item{vrb}{String, vector, or unquoted expression with variable name(s), default is "all".}

\item{label}{Logical indicating whether variable names should be displayed within the plot (the default) or with colors in the legend.}

\item{caption}{Logical indicating whether the figure caption should be displayed.}
}
\value{
An object of class \link[ggplot2:ggplot]{ggplot2::ggplot}.
}
\description{
Plot the influx and outflux of a multivariate missing data pattern
}
\examples{
# plot flux for all columns
plot_flux(mice::nhanes)

# plot flux for specific columns by supplying a character vector
plot_flux(mice::nhanes, c("chl", "hyp"))

# plot flux for specific columns by supplying unquoted variable names
plot_flux(mice::nhanes, c(chl, hyp))

# plot flux for specific columns by passing an object with variable names
# from the environment, unquoted with `!!`
my_variables <- c("chl", "hyp")
plot_flux(mice::nhanes, !!my_variables)
# object with variable names must be unquoted with `!!`
try(plot_flux(mice::nhanes, my_variables))

}
