% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotVariableMatrix}
\alias{plotVariableMatrix}
\title{Returns the image object to show the heat map of dates between the inputted set of vertices}
\usage{
plotVariableMatrix(
  varieties,
  geneal,
  colName,
  xLab = "Variety",
  yLab = "Variety",
  legendLab = "Difference in variable"
)
}
\arguments{
\item{varieties}{subset of varieties used to generate the heat map}

\item{geneal}{the full genealogy  (in data frame format)}

\item{colName}{the name of the column of the data frame that contains the quantitative variable of interest (in character string format)}

\item{xLab}{string label on the x axis (default is "Variety")}

\item{yLab}{string label on the y axis (default is "Variety")}

\item{legendLab}{string label on the legend (default is "Degree")}
}
\description{
Returns the image object to show the heat map of dates between the inputted set of vertices
}
\examples{
data(sbGeneal)
varieties <- c("Bedford", "Calland", "Narow", "Pella", "Tokyo", "Young", "Zane")
p <- plotVariableMatrix(varieties, sbGeneal, "devYear", "Variety", "Variety", "Difference")
p + ggplot2::scale_fill_continuous(low = "white", high = "darkgreen")
}
\references{
Rutter L, VanderPlas S, Cook D, Graham MA (2019).
ggenealogy: An R Package for Visualizing Genealogical Data.
\emph{Journal of Statistical Software},
\bold{89}(13), 1--31.
\doi{10.18637/jss.v089.i13}
}
