% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circles.R
\name{ob_circle}
\alias{ob_circle}
\title{ob_circle class}
\usage{
ob_circle(
  center = ob_point(0, 0),
  radius = 1,
  label = character(0),
  alpha = numeric(0),
  color = character(0),
  fill = character(0),
  linewidth = numeric(0),
  linetype = numeric(0),
  n = numeric(0),
  style = S7::class_missing,
  x = numeric(0),
  y = numeric(0),
  id = character(0),
  ...
)
}
\arguments{
\item{center}{point at center of the circle}

\item{radius}{distance between center and edge circle}

\item{label}{A character, angle, or label object}

\item{alpha}{numeric value for alpha transparency}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{linewidth}{Width of lines}

\item{linetype}{type of lines}

\item{n}{number of points in circle (default = 360)}

\item{style}{an ob_style object}

\item{x}{x-coordinate of center point. If specified, overrides x-coordinate of \verb{@center}.}

\item{y}{x-coordinate of center point. If specified, overrides y-coordinate of \verb{@center}.}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to style object}
}
\value{
ob_circle object
}
\description{
ob_circle class
}
\section{Slots}{

\describe{
\item{\code{aesthetics}}{A list of information about the circle's aesthetic properties}

\item{\code{angle_at}}{A function that finds the angle of the specified point in relation to the circle's center}

\item{\code{area}}{area of the circle}

\item{\code{bounding_box}}{a rectangle that contains all the circles}

\item{\code{circumference}}{circumference of the circle}

\item{\code{geom}}{A function that converts the object to a geom. Any additional parameters are passed to \code{ggforce::geom_circle}.}

\item{\code{length}}{The number of circles in the circle object}

\item{\code{normal_at}}{A function that finds a point that is perpendicular from the circle and at a specified distance}

\item{\code{point_at}}{A function that finds a point on the circle at the specified angle.}

\item{\code{polygon}}{a tibble containing information to create all the polygon points in a circle.}

\item{\code{tangent_at}}{A function that finds the tangent line at the specified angle.}

\item{\code{tibble}}{Gets a tibble (data.frame) containing parameters and styles used by \code{ggforce::geom_cirlce}.}
}}

\examples{
# specify center point and radius
ob_circle(center = ob_point(0,0), radius = 6)
}
