% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osgb.R
\name{osgb_fwd}
\alias{osgb_fwd}
\alias{osgb_rev}
\alias{osgb_gridref}
\alias{osgb_gridref_rev}
\title{Ordnance Survey National Grid (Great Britain)}
\usage{
osgb_fwd(x)

osgb_rev(easting, northing)

osgb_gridref(x, precision = 2L)

osgb_gridref_rev(gridref)
}
\arguments{
\item{x}{For \code{osgb_fwd()} and \code{osgb_gridref()}: a two-column matrix or
data frame of OSGB36 coordinates (longitude, latitude) in decimal degrees.}

\item{easting}{Numeric vector of OSGB eastings in meters.}

\item{northing}{Numeric vector of OSGB northings in meters.}

\item{precision}{Integer specifying the precision of grid references:
\itemize{
\item -1: 500 km squares (first letter only)
\item 0: 100 km squares (two letters)
\item 1: 10 km (2 digits)
\item 2: 1 km (4 digits)
\item 3: 100 m (6 digits)
\item 4: 10 m (8 digits)
\item 5: 1 m (10 digits)
}}

\item{gridref}{Character vector of OSGB grid reference strings.}
}
\value{
\itemize{
\item \code{osgb_fwd()}: Data frame with columns:
\itemize{
\item \code{easting}: OSGB easting in meters
\item \code{northing}: OSGB northing in meters
\item \code{convergence}: Grid convergence in degrees
\item \code{scale}: Scale factor
\item \code{lon}, \code{lat}: Input OSGB36 coordinates (echoed)
}
\item \code{osgb_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: OSGB36 longitude in decimal degrees
\item \code{lat}: OSGB36 latitude in decimal degrees
\item \code{convergence}: Grid convergence in degrees
\item \code{scale}: Scale factor
\item \code{easting}, \code{northing}: Input coordinates (echoed)
}
\item \code{osgb_gridref()}: Character vector of grid reference strings.
\item \code{osgb_gridref_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: OSGB36 longitude in decimal degrees
\item \code{lat}: OSGB36 latitude in decimal degrees
\item \code{easting}: OSGB easting in meters
\item \code{northing}: OSGB northing in meters
\item \code{precision}: Precision level of the grid reference
}
}
}
\description{
Convert between geographic coordinates and the Ordnance Survey
National Grid used in Great Britain.

\strong{Important:} These functions expect coordinates on the OSGB36 datum,
not WGS84. For WGS84 coordinates (e.g., from GPS), you need to perform
a datum transformation first using another package such as sf.
}
\details{
The Ordnance Survey National Grid is a geographic grid reference system
used in Great Britain. It uses the OSGB36 datum and a Transverse Mercator
projection.

Grid references are alphanumeric codes like "TQ3080" for central London.
The format is two letters (100 km square) followed by an even number of digits.

\strong{Datum note:} The difference between WGS84 and OSGB36 can be up to ~100m.
For precise work, transform WGS84 coordinates to OSGB36 first.
}
\examples{
# OSGB36 coordinates for central London (not WGS84!)
# In practice, you would transform from WGS84 first
london_osgb36 <- c(-0.1270, 51.5072)

# Convert to OSGB grid
osgb_fwd(london_osgb36)

# Get grid reference at various precisions
osgb_gridref(london_osgb36, precision = 2)  # 1 km
osgb_gridref(london_osgb36, precision = 3)  # 100 m
osgb_gridref(london_osgb36, precision = 4)  # 10 m

# Parse a grid reference
osgb_gridref_rev("TQ3080")

# Round-trip conversion
fwd <- osgb_fwd(london_osgb36)
osgb_rev(fwd$easting, fwd$northing)
}
