% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic_fast.R
\name{geodesic_direct_fast}
\alias{geodesic_direct_fast}
\alias{geodesic_inverse_fast}
\alias{geodesic_path_fast}
\alias{geodesic_distance_fast}
\alias{geodesic_distance_matrix_fast}
\title{Fast geodesic calculations (series approximation)}
\usage{
geodesic_direct_fast(x, azi, s)

geodesic_inverse_fast(x, y)

geodesic_path_fast(x, y, n = 100L)

geodesic_distance_fast(x, y)

geodesic_distance_matrix_fast(x, y = NULL)
}
\arguments{
\item{x}{A two-column matrix or data frame of starting coordinates
(longitude, latitude) in decimal degrees.}

\item{azi}{Numeric vector of azimuths (bearings) in degrees, measured
clockwise from north.}

\item{s}{Numeric vector of distances in meters.}

\item{y}{A two-column matrix or data frame of ending coordinates
(longitude, latitude) in decimal degrees.}

\item{n}{Integer number of points to generate along the path (including
start and end points).}
}
\value{
Same as the corresponding exact geodesic functions.
}
\description{
These functions provide the same geodesic calculations as \code{geodesic_direct()},
\code{geodesic_inverse()}, etc., but use a series approximation that is slightly
faster at the cost of reduced precision (accurate to ~15 nanometers vs
full double precision for the exact versions).

For most applications, the difference is negligible and these faster
versions are recommended.
}
\examples{
# Fast inverse: London to New York
geodesic_inverse_fast(c(-0.1, 51.5), c(-74, 40.7))

# Compare to exact version
geodesic_inverse(c(-0.1, 51.5), c(-74, 40.7))$s12
geodesic_inverse_fast(c(-0.1, 51.5), c(-74, 40.7))$s12
}
\seealso{
\code{\link[=geodesic_direct]{geodesic_direct()}}, \code{\link[=geodesic_inverse]{geodesic_inverse()}} for exact versions
}
