% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs_api.R
\name{wfs_api}
\alias{wfs_api}
\title{WFS API}
\usage{
wfs_api(base_url = "https://geo.stat.fi/geoserver/wfs", queries)
}
\arguments{
\item{base_url}{string Api base url}

\item{queries}{list List of query parameters}
}
\value{
wfs_api (S3) object with the following attributes:
\describe{
\item{content}{XML payload.}
\item{path}{path provided to get the resonse.}
\item{response}{the original response object.}
}
}
\description{
Requests to various WFS API.
}
\details{
Make a request to the spesific WFS API. The base url is
http://geo.stat.fi/geoserver/wfs to which other
components defined by the arguments are appended.

This is a low-level function intended to be used by other higher level
functions in the package.

Note that GET requests are used using \code{httpcache} meaning that requests
are cached. If you want clear cache, use \code{\link[httpcache:cache-management]{httpcache::clearCache()}}. To turn
the cache off completely, use \code{\link[httpcache:cache-management]{httpcache::cacheOff()}}
}
\examples{
  wfs_api(base_url = "http://geo.stat.fi/geoserver/wfs",
          queries = append(list("service" = "WFS", "version" = "1.0.0"),
                list(request = "getFeature",
                     layer = "tilastointialueet:kunta4500k_2017")))

}
\author{
Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
