% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_statistical_grid.R
\name{get_statistical_grid}
\alias{get_statistical_grid}
\title{Get Statistical grid data polygons at two different resolution}
\usage{
get_statistical_grid(resolution = 5, auxiliary_data = FALSE)
}
\arguments{
\item{resolution}{integer 1 (1km x 1km) or 5 (5km x 5km)}

\item{auxiliary_data}{logical Whether to include auxiliary data containing municipality membership data. Default \code{FALSE}}
}
\value{
sf object
}
\description{
Thin wrapper around Finnish statistical grid data provided by
\href{https://stat.fi/en/services/statistical-data-services/geographic-data/population-grid-data-1-km}{Statistics Finland}.
}
\examples{
 \dontrun{
 f <- get_statistical_grid(resolution = 5, auxiliary_data = FALSE)
 plot(f)
 }

}
\author{
Markus Kainu \href{mailto:markus.kainu@kela.fi}{markus.kainu@kela.fi}, Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
