% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeted.R
\name{targeted}
\alias{targeted}
\title{Targeted Analysis}
\usage{
targeted(
  data_list,
  MOIs,
  RTs = c(),
  window_size = c(),
  tolerance = 0.005,
  images = FALSE
)
}
\arguments{
\item{data_list}{a \emph{list} object. Data extracted from each cdf file,
ideally the output from extract_data().}

\item{MOIs}{a \emph{vector} object. A vector containing a list of all masses
of interest to be investigated.}

\item{RTs}{a \emph{vector} object. An optional vector containing a list of
retention times of interest for the listed masses of interest. Default values
if left empty will be at the retention time of the highest intensity for the
corresponding mass.}

\item{window_size}{a \emph{vector} object. An optional vector containing a
list of window sizes corresponding to the retention times.  Window will be
defined by (RT-window_size, RT+window_size). Default if left
empty will be 0.1.}

\item{tolerance}{a \emph{float} object. The tolerance allowed for the MOI.
Default is 0.005.}

\item{images}{a \emph{boolean} object. An optional input. If TRUE, all images
of the found peaks will be displayed. Default is FALSE, no images will be
displayed.}
}
\value{
a \emph{data.frame} object. A data frame containing the areas of the
peaks for the indicated MOIs and list of files.
}
\description{
\code{targeted} performs targeted analysis for a batch of data
files, for a list of masses of interest.
}
\details{
This function performs targeted analysis for a batch of data
files, for a list of masses of interest.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
file2 <- system.file("extdata","sample2.cdf",package="gcxgclab")
file3 <- system.file("extdata","sample3.cdf",package="gcxgclab")
frame1 <- extract_data(file1,mod_t=.5)
frame2 <- extract_data(file2,mod_t=.5)
frame3 <- extract_data(file3,mod_t=.5)
targeted(list(frame1,frame2,frame3),MOIs = c(92.1397, 93.07058),
RTs = c(6.930, 48.594), images=TRUE)

}
