% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data.R
\name{extract_data}
\alias{extract_data}
\title{Extracts data from cdf file.}
\usage{
extract_data(filename, mod_t = 10, shift_time = TRUE)
}
\arguments{
\item{filename}{a \emph{string} object. The path or file name of the cdf
file to be opened.}

\item{mod_t}{a \emph{float} object. The modulation time for the GCxGC sample
analysis. Default is 10.}

\item{shift_time}{a \emph{boolean} object. Determines whether the Overall
Time Index should be shifted to 0. Default is TRUE.}
}
\value{
A \emph{list} object. A list of the extracted data: scan acquisition
time, total intensity, mass values, intensity values, and point count.
}
\description{
\code{extract_data} Extracts the data from a cdf file.
}
\details{
This function opens the specified cdf file using the implemented
function \code{\link[ncdf4]{nc_open}} from ncdf4 package, then extracts the
data and closes the cdf file using the implemented function
\code{\link[ncdf4]{nc_close}} from ncdf4 package
\insertCite{ncdf4}{gcxgclab}. It then returns a list of two data frames. The
first is a dataframe of the TIC data,and The second is a data frame of the
full MS data.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
plot_chr(frame, title='Raw Data', scale="linear")
plot_chr(frame, title='Log Intensity')

}
\references{
\insertAllCited{}
}
