% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-collect.R
\name{collect.data_request}
\alias{collect.data_request}
\alias{collect.metadata_request}
\alias{collect.files_request}
\alias{collect.prequery}
\alias{collect.query}
\alias{collect.query_set}
\alias{collect.computed_query}
\title{Retrieve a database query}
\usage{
\method{collect}{data_request}(x, ..., wait = TRUE, file = NULL)

\method{collect}{metadata_request}(x, ...)

\method{collect}{files_request}(x, ...)

\method{collect}{prequery}(x, ...)

\method{collect}{query}(x, ...)

\method{collect}{query_set}(x, ..., wait = TRUE, file = NULL)

\method{collect}{computed_query}(x, ..., wait = TRUE, file = NULL)
}
\arguments{
\item{x}{An object of class \code{data_request}, \code{metadata_request} or
\code{files_request} (from \code{galah_call()}); or an object of class \code{prequery},
\code{query_set} or \code{query} (from \code{\link[=capture]{capture()}},
\code{\link[=collapse.data_request]{collapse()}}
or \code{\link[=compute.data_request]{compute()}})}

\item{...}{Arguments passed on to other methods}

\item{wait}{logical; should \code{galah} wait for a response? Defaults to \code{FALSE}.
Only applies for \code{type = "occurrences"} or \code{"species"}.}

\item{file}{(Optional) file name. If not given, will be set to \code{data} with
date and time added. The file path (directory) is always given by
\code{galah_config()$package$directory}.}
}
\value{
In most cases, \code{collect()} returns a \code{tibble} containing requested
data. Where the requested data are not yet ready (i.e. for occurrences when
\code{wait} is set to \code{FALSE}), this function returns an object of class \code{query}
that can be used to recheck the download at a later time.
}
\description{
Retrieve the result of a query from the server. It is the
default way to end a piped query that begins with \code{\link[=galah_call]{galah_call()}}.
}
\details{
\code{galah} uses an object-based pipeline to convert piped requests into
valid queries, and to enact those queries with the specified organisation.
Typically, requests open with \code{\link[=galah_call]{galah_call()}} - though \code{\link[=request_metadata]{request_metadata()}}
and \code{\link[=request_files]{request_files()}} are also valid - and end with
\code{\link[=collect.data_request]{collect()}}. Under the hood,
the sequence of functions is as follows:

\code{\link[=capture]{capture()}} → \code{\link[=compound]{compound()}} →
\code{\link[=collapse.data_request]{collapse()}} →
\code{\link[=compute.data_request]{compute()}} →
\code{\link[=collect.data_request]{collect()}}

\code{\link[=collect.data_request]{collect()}} is the final step of the
\code{\link[=galah_call]{galah_call()}} workflow, and it retrieves the result of a
query once it is processed by the server.
}
\seealso{
To open a piped query, see \code{\link[=galah_call]{galah_call()}}. For alternative
operations on \verb{_request} objects, see \code{\link[=capture]{capture()}}, \code{\link[=compound]{compound()}},
\code{\link[=collapse.data_request]{collapse()}} or
\code{\link[=compute.data_request]{compute()}}.
}
