#' @rdname atlas_
#' @order 2
#' @param group_by `tibble`: generated by a call to [galah_group_by()].
#' @param limit `numeric`: maximum number of categories to return, defaulting to 100.
#' If limit is NULL, all results are returned. For some categories this will
#' take a while.
#' @param type `string`: one of `"occurrences"` or `"species"`. 
#' Defaults to `"occurrences"`, which returns the number of records
#' that match the selected criteria; alternatively returns the number of 
#' species.
#' @export
atlas_counts <- function(request = NULL, 
                         identify = NULL, 
                         filter = NULL, 
                         geolocate = NULL,
                         apply_profile = NULL,
                         group_by = NULL, 
                         limit = NULL,
                         type = c("occurrences", "species")
                         ) {
  # capture supplied arguments
  args <- as.list(environment())
  args$type <- match.arg(type)
  # convert to `data_request` object, collect
  check_atlas_inputs(args) |>
    count() |>
    slice_head(n = limit) |>
    collect()
}