% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_match.R
\name{check_match}
\alias{check_match}
\title{Test whether two strings match with an LLM prompt.}
\usage{
check_match(
  string1,
  string2,
  model = "gpt-5.2",
  record_type = "entity",
  instructions = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  parallel = TRUE
)
}
\arguments{
\item{string1}{A string or vector of strings}

\item{string2}{A string or vector of strings}

\item{model}{Which LLM to prompt; defaults to 'gpt-5.2'. Also accepts Mistral models (e.g. 'mistral-large-latest') and Anthropic Claude models (e.g. 'claude-sonnet-4-5-20250929').}

\item{record_type}{A character describing what type of entity \code{string1} and \code{string2} represent. Should be a singular noun (e.g. "person", "organization", "interest group", "city").}

\item{instructions}{A string containing additional instructions to include in the LLM prompt.}

\item{openai_api_key}{Your OpenAI API key. By default, looks for a system environment variable called "OPENAI_API_KEY" (recommended option). Otherwise, it will prompt you to enter the API key as an argument.}

\item{parallel}{TRUE to submit API requests in parallel. Setting to FALSE can reduce rate limit errors at the expense of longer runtime.}
}
\value{
A vector the same length as \code{string1} and \code{string2}. "Yes" if the pair of strings match, "No" otherwise.
}
\description{
Test whether two strings match with an LLM prompt.
}
\examples{
\dontrun{
check_match('UPS', 'United Parcel Service')
check_match('UPS', 'United States Postal Service')
check_match(c('USPS', 'USPS', 'USPS'),
            c('Post Office', 'United Parcel', 'US Postal Service'))
}
}
