% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fude.R
\name{read_fude}
\alias{read_fude}
\title{Read a Fude Polygon ZIP file}
\usage{
read_fude(
  path = NULL,
  pref = NULL,
  year = 2025,
  rcom_year = 2020,
  supplementary = FALSE,
  to_wgs84 = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{path}{Path to a ZIP file containing one or more supported spatial files
(\code{.geojson}, \code{.json}, and \code{.fgb}).}

\item{pref}{Prefecture name or a two-digit prefecture code.}

\item{year}{Year when the Fude Polygon data were created.}

\item{rcom_year}{Year of the agricultural community boundary data.}

\item{supplementary}{Logical. If \code{TRUE}, add supplementary information for each polygon.}

\item{to_wgs84}{Logical. If \code{TRUE}, transform coordinates to WGS 84 (EPSG:4326).}

\item{quiet}{Logical. If \code{TRUE}, suppress messages about reading progress.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} objects.
}
\description{
\code{read_fude()} reads MAFF Fude Polygon data from a ZIP file and returns the
layers as a list of \code{\link[sf:sf]{sf::sf()}} objects. The ZIP may contain one or more spatial
data files such as \strong{GeoJSON} (\code{.json} or \code{.geojson}) and \strong{FlatGeobuf}
(\code{.fgb}). The function also works with ZIP files you created, as long as
the original filenames are unchanged.
}
\examples{
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path)

}
