% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_boundary.R
\name{extract_boundary}
\alias{extract_boundary}
\title{Extract specified agricultural community boundary data}
\usage{
extract_boundary(boundary, city = "", kcity = "", rcom = "", layer = FALSE)
}
\arguments{
\item{boundary}{Agricultural community boundary data as returned by \code{\link[=get_boundary]{get_boundary()}}.}

\item{city}{A character vector of local government names or 6-digit local government
codes to extract.}

\item{kcity}{A regular expression. One or more former municipality names (in Japanese)
to extract.}

\item{rcom}{A regular expression. One or more agricultural community names (in
Japanese) to extract.}

\item{layer}{Logical. If \code{TRUE}, the returned object includes not only agricultural
community boundaries but also prefecture and municipality boundaries.}
}
\value{
An \code{\link[sf:sf]{sf::sf()}} object.
}
\description{
\code{extract_boundary()} extracts specified subsets of agricultural community
boundary data returned by \code{\link[=get_boundary]{get_boundary()}}.
}
\seealso{
\code{\link[=read_fude]{read_fude()}}.
}
