% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_fude.R
\name{combine_fude}
\alias{combine_fude}
\title{Combine the Fude Polygon data with the agricultural community boundary data}
\usage{
combine_fude(data, boundary, city, kcity = "", rcom = "", year = NULL)
}
\arguments{
\item{data}{Fude Polygon data as returned by \code{\link[=read_fude]{read_fude()}}.}

\item{boundary}{Agricultural community boundary data as returned by \code{\link[=get_boundary]{get_boundary()}}.}

\item{city}{A character vector of local government names or 6-digit local government
codes to extract.}

\item{kcity}{A regular expression. One or more former municipality names (in Japanese)
to extract.}

\item{rcom}{A regular expression. One or more agricultural community names (in
Japanese) to extract.}

\item{year}{Year in the column name of the \code{data}. If there is more than one applicable
local government code, it is required.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} objects.
}
\description{
\code{combine_fude()} uses the agricultural community boundary data to reduce the
Fude Polygon data to the community units.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path, stringsAsFactors = FALSE)
b <- get_boundary(d)
db <- combine_fude(d, b, "\u677e\u5c71\u5e02", "\u57ce\u6771", year = 2022)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=read_fude]{read_fude()}}.
}
