% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_front_matter.R
\name{format_front_matter}
\alias{format_front_matter}
\alias{write_front_matter}
\title{Format and Write YAML or TOML Front Matter}
\usage{
format_front_matter(
  x,
  delimiter = "yaml",
  format = "auto",
  format_yaml = NULL,
  format_toml = NULL
)

write_front_matter(
  x,
  path = NULL,
  delimiter = "yaml",
  ...,
  format = "auto",
  format_yaml = NULL,
  format_toml = NULL
)
}
\arguments{
\item{x}{A list with \code{data} and \code{body} elements, typically as returned by
\code{\link[=parse_front_matter]{parse_front_matter()}} or \code{\link[=read_front_matter]{read_front_matter()}}. The \code{data} element
contains the metadata to serialize (can be \code{NULL} to write body only),
and \code{body} contains the document content (can be \code{NULL} or empty).}

\item{delimiter}{A character string specifying the fence style, or a
character vector for custom delimiters. See \strong{Delimiter Formats} for
available options.}

\item{format}{The serialization format: \code{"auto"} (detect from delimiter),
\code{"yaml"}, or \code{"toml"}. Usually auto-detection works well.}

\item{format_yaml, format_toml}{Custom formatter functions, or \code{NULL} to use
defaults. Each function should accept an R object and return a character
string.}

\item{path}{File path to write to, or \code{NULL} to print to the console}

\item{...}{Additional arguments passed to \code{\link[=writeBin]{writeBin()}} when writing to a
file (e.g., \code{useBytes}).}
}
\value{
\itemize{
\item \code{format_front_matter()}: A character string containing the formatted
document with front matter.
\item \code{write_front_matter()}: Called for its side effect; returns \code{NULL}
invisibly.
}
}
\description{
Serialize R data as YAML or TOML front matter and combine it with document
content. \code{format_front_matter()} returns the formatted document as a string,
while \code{write_front_matter()} writes it to a file or prints to the console.
These functions are the inverse of \code{\link[=parse_front_matter]{parse_front_matter()}} and
\code{\link[=read_front_matter]{read_front_matter()}}.
}
\section{Functions}{
\itemize{
\item \code{format_front_matter()}: Format front matter as a string

\item \code{write_front_matter()}: Write front matter to a file or console

}}
\section{Delimiter Formats}{


The \code{delimiter} argument controls the fence style used to wrap the front
matter. You can use these built-in shortcuts:\tabular{lllll}{
   Shortcut \tab Format \tab Opening \tab Closing \tab Use Case \cr
   \code{"yaml"} \tab YAML \tab \verb{---} \tab \verb{---} \tab Markdown, R Markdown, Quarto \cr
   \code{"toml"} \tab TOML \tab \verb{+++} \tab \verb{+++} \tab Hugo, some static site generators \cr
   \code{"yaml_comment"} \tab YAML \tab \verb{# ---} \tab \verb{# ---} \tab R scripts, Python scripts \cr
   \code{"toml_comment"} \tab TOML \tab \verb{# +++} \tab \verb{# +++} \tab R scripts, Python scripts \cr
   \code{"yaml_roxy"} \tab YAML \tab \verb{#' ---} \tab \verb{#' ---} \tab Roxygen2 documentation \cr
   \code{"toml_roxy"} \tab TOML \tab \verb{#' +++} \tab \verb{#' +++} \tab Roxygen2 documentation \cr
   \code{"toml_pep723"} \tab TOML \tab \verb{# /// script} \tab \verb{# ///} \tab Python PEP 723 inline metadata \cr
}


For custom delimiters, pass a character vector of length 1, 2, or 3:
\itemize{
\item \strong{Length 1}: Used as both opener and closer, with no line prefix
\item \strong{Length 2}: \code{c(opener, prefix)} where opener is also used as closer
\item \strong{Length 3}: \code{c(opener, prefix, closer)} for full control
}
}

\section{Custom Formatters}{


By default, the package uses \code{\link[yaml12:format_yaml]{yaml12::format_yaml()}} for YAML and
\code{\link[tomledit:write]{tomledit::to_toml()}} for TOML. You can provide custom formatter functions
via \code{format_yaml} and \code{format_toml} to override these defaults.

Custom formatters must accept an R object and return a character string
containing the serialized content.
}

\section{YAML Specification Version}{


The default YAML formatter uses YAML 1.2 via \code{\link[yaml12:format_yaml]{yaml12::format_yaml()}}. To use
YAML 1.1 formatting instead (via \code{\link[yaml:as.yaml]{yaml::as.yaml()}}), set either:
\itemize{
\item The R option \code{frontmatter.serialize_yaml.spec} to \code{"1.1"}
\item The environment variable \code{FRONTMATTER_SERIALIZE_YAML_SPEC} to \code{"1.1"}
}

The option takes precedence over the environment variable. Valid values are
\code{"1.1"} and \code{"1.2"} (the default).
}

\section{Roundtrip Support}{


Documents formatted with these functions can be read back with
\code{\link[=parse_front_matter]{parse_front_matter()}} or \code{\link[=read_front_matter]{read_front_matter()}}. For comment-prefixed
formats (like \code{yaml_comment} or \code{yaml_roxy}), a separator line is
automatically inserted between the closing fence and the body when the body
starts with the same comment prefix, ensuring clean roundtrip behavior.
}

\examples{
# Create a document with YAML front matter
doc <- list(
  data = list(title = "My Document", author = "Jane Doe"),
  body = "Document content goes here."
)

# Format as a string
format_front_matter(doc)

# Write to a file
tmp <- tempfile(fileext = ".md")
write_front_matter(doc, tmp)
readLines(tmp)

# Print to console (when path is NULL)
write_front_matter(doc)

# Use TOML format
format_front_matter(doc, delimiter = "toml")

# Use comment-wrapped format for R scripts
r_script <- list(
  data = list(title = "Analysis Script"),
  body = "# Load libraries\nlibrary(dplyr)"
)
format_front_matter(r_script, delimiter = "yaml_comment")

# Roundtrip example: read, modify, write
original <- "---
title: Original
---
Content here"

doc <- parse_front_matter(original)
doc$data$title <- "Modified"
format_front_matter(doc)

}
\seealso{
\code{\link[=parse_front_matter]{parse_front_matter()}} and \code{\link[=read_front_matter]{read_front_matter()}} for the inverse
operations.
}
