% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biginteger-friendly.R
\name{biginteger_friendly}
\alias{biginteger_friendly}
\alias{biginteger_friendly_safe}
\title{Translate a biginteger to a cardinal character vector}
\usage{
biginteger_friendly(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE
)

biginteger_friendly_safe(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE
)
}
\arguments{
\item{numbers}{\verb{[bignum_biginteger]}

A \code{\link[bignum:biginteger]{bignum::biginteger()}} vector to translate.}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{and}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the tens place of translated \code{numbers}.
\code{and} is \code{FALSE} by default.}

\item{hyphenate}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 (e.g. \code{"twenty-one"} vs. \code{"twenty one"}).
\code{hyphenate} is \code{TRUE} by default.}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert a \verb{<bignum_biginteger>} to a cardinal numeral (e.g. one, two, three).

A \code{\link[bignum:biginteger]{bignum::biginteger()}} can store any integer (i.e. arbitrary precision),
which is useful for manipulating numbers too large to be represented (accurately)
in an \verb{<integer>} or \verb{<numeric>} vector.

\code{biginteger_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{biginteger_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
\dontshow{if (requireNamespace("bignum", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
biginteger_friendly(bignum::biginteger(c(0, 1, 2, NA, 10001)))

# Specify the translations of "special" numbers
biginteger_friendly(bignum::biginteger(-10), negative = "minus ")
biginteger_friendly(bignum::biginteger(NA), na = "unknown")

# Modify the output formatting
biginteger_friendly(bignum::biginteger(9999))
biginteger_friendly(bignum::biginteger(9999), and = TRUE)
biginteger_friendly(bignum::biginteger(9999), hyphenate = FALSE)

# Translate large numbers
large <- bignum::biginteger(10L)^1001L
biginteger_friendly(large)

# Input validation
try(biginteger_friendly_safe(1L))
\dontshow{\}) # examplesIf}
}
