% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{save_report}
\alias{save_report}
\title{Save a report to the outputs directory}
\usage{
save_report(file, name = NULL, public = FALSE, overwrite = TRUE, move = FALSE)
}
\arguments{
\item{file}{Path to the report file to save}

\item{name}{Optional new name for the file (without extension). If NULL, uses original name.}

\item{public}{If TRUE, saves to public outputs directory (for project_sensitive type)}

\item{overwrite}{If TRUE, overwrites existing files (default: TRUE)}

\item{move}{If TRUE, moves the file instead of copying (default: FALSE)}
}
\value{
The path to the saved file (invisibly)
}
\description{
Copies or moves a rendered report (HTML, PDF, etc.) to the configured reports directory.
The directory is created lazily on first use.
}
\examples{
\donttest{
if (FALSE) {
# Save a rendered HTML report
save_report("notebooks/analysis.html", "final_analysis")

# Save to public directory
save_report("notebooks/summary.pdf", "public_summary", public = TRUE)
}
}

}
