% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drivers.R
\name{db_drivers_status}
\alias{db_drivers_status}
\title{Check if database drivers are installed}
\usage{
db_drivers_status(quiet = FALSE)
}
\arguments{
\item{quiet}{Logical. If TRUE, suppresses messages. Default: FALSE}
}
\value{
A data frame with columns:
\itemize{
\item driver: Database driver name
\item package: Required R package
\item installed: Whether the package is installed
\item version: Package version (if installed)
}
}
\description{
Checks which database drivers are currently available on the system.
Returns a data frame showing the status of all supported database drivers.
}
\examples{
\donttest{
# Check all drivers
db_drivers_status()

# Quiet mode (no messages)
db_drivers_status(quiet = TRUE)
}

}
