% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure.R
\name{configure_directories}
\alias{configure_directories}
\title{Configure Project Directories}
\usage{
configure_directories(directory = NULL, path = NULL, interactive = TRUE)
}
\arguments{
\item{directory}{Character. Directory name to configure (e.g., "notebooks", "scripts")}

\item{path}{Character. Path for the directory}

\item{interactive}{Logical. If TRUE, prompts for missing values. Default TRUE.}
}
\value{
Invisibly returns updated config
}
\description{
Interactively configure project directory structure in settings.yml (or settings.yml for legacy projects).
Directories control where Framework creates and looks for files.
}
\details{
\subsection{Standard Directories}{
\itemize{
\item \code{notebooks} - Where make_notebook() creates files
\item \code{scripts} - Where make_script() creates files
\item \code{functions} - Where scaffold() looks for custom functions
\item \code{inputs_raw} - Source data (gitignored)
\item \code{inputs_intermediate} - Cleaned-but-input datasets
\item \code{inputs_final} - Curated analytic datasets
\item \code{inputs_reference} - External documentation/codebooks
\item \code{outputs_private} - Working artifacts (tables/figures/models)
\item \code{outputs_public} - Share-ready artifacts
\item \code{outputs_docs} - Narrative/report outputs (private)
\item \code{outputs_docs_public} - Narrative/report outputs (public)
\item \code{cache} - Cached computation results
\item \code{scratch} - Temporary workspace
}
}
}
\keyword{internal}
