% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_coef}
\alias{qr_coef}
\title{Compute least-squares coefficients from a QR decomposition}
\usage{
qr_coef(qr, tau, y, pivot = NULL, rank = NULL)
}
\arguments{
\item{qr}{numeric matrix containing the QR decomposition of \eqn{X}
in compact form (as returned by \code{qr_fast()}).}

\item{tau}{numeric vector of Householder coefficients.}

\item{y}{numeric response vector of length \eqn{n}.}

\item{pivot}{optional integer vector of length \eqn{p} containing the
1-based column permutation used during the QR factorization. If supplied,
the returned coefficients are reordered to match the original column order.}

\item{rank}{optional integer specifying the numerical rank of \eqn{X}. If
supplied, only the leading \code{rank} components are used in the
triangular solve.}
}
\value{
a numeric vector of regression coefficients.
}
\description{
Computes the coefficient vector \eqn{\widehat\beta} solving the
least-squares problem \eqn{\min_\beta \|y - X\beta\|_2},
using a QR decomposition stored in compact (Householder) form.
}
\details{
The coefficients are obtained by first computing \eqn{Q^\top y}
and then solving the resulting upper-triangular system involving
the matrix \eqn{R}. The orthogonal matrix \eqn{Q} is never formed
explicitly.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

qr_res <- fastQR::qr_fast(X)
coef1  <- fastQR::qr_coef(qr = qr_res$qr, tau = qr_res$qraux, y = y)

## reference computation
coef2 <- base::qr.coef(base::qr(X), y)

max(abs(coef1 - coef2))

}
