% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{fmm_to_SparseM}
\alias{fmm_to_SparseM}
\title{Convert Matrix Market File to SparseM matrix.csr}
\usage{
fmm_to_SparseM(filename)
}
\arguments{
\item{filename}{The name of the input Matrix Market file to be read.}
}
\value{
A matrix.csr object containing the data read from the Matrix Market
file.
}
\description{
This function reads a Matrix Market file and converts it to a
matrix.csr object using the SparseM package.
}
\examples{
\dontshow{if (requireNamespace("SparseM", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sample_sparse <- Matrix::Matrix(c(1, 0, 0, 2), nrow = 2, sparse = TRUE)
tmp <- tempfile(fileext = ".mtx")
write_fmm(sample_sparse, tmp)
csr <- fmm_to_SparseM(tmp)
\dontshow{\}) # examplesIf}
}
