% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{SparseM_to_fmm}
\alias{SparseM_to_fmm}
\title{Convert a SparseM matrix.csr to Matrix Market Format}
\arguments{
\item{input}{A matrix.csr object to be converted.}

\item{filename}{The name of the output file where the Matrix Market formatted
data will be saved.}
}
\value{
A boolean indicating success or failure. Writes a MTX file to disk.
}
\description{
This function takes a SparseM matrix.csr and converts it into a
Matrix Market file.
}
\examples{
\dontshow{if (requireNamespace("SparseM", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
csr <- SparseM::as.matrix.csr(matrix(c(1, 0, 0, 2), nrow = 2))
SparseM_to_fmm(csr, tempfile(fileext = ".mtx"))
\dontshow{\}) # examplesIf}
}
