% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{predcond}
\alias{predcond}
\title{Predicts means and variances conditionally on the factors}
\usage{
predcond(x, ahead = 1, each = 1, ...)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{ahead}{Vector of timepoints, indicating how many steps
to predict ahead.}

\item{each}{Single integer (or coercible to such) indicating how
often should be drawn from the posterior predictive distribution
for each draw that has been stored during MCMC sampling.}

\item{...}{Ignored.}
}
\value{
List of class \code{fsvpredcond} containing two elements:
\describe{
\item{means}{Array containing the draws of the predictive means.}
\item{vols}{Array containing the draws of the predictive volatilities (square root of variances).}
}
}
\description{
\code{predcond} simulates from the posterior predictive distribution
of the data, conditionally on realized values of the factors. This
has the advantage that the predictive density can be written as
the product of the marginals but introduces sampling uncertainty
that grows with the number of factors used.
}
\examples{
\donttest{
set.seed(1)
sim <- fsvsim(n = 500, series = 4, factors = 1) # simulate
res <- fsvsample(sim$y, factors = 1) # estimate

# Predict 1 day ahead:
predobj <- predcond(res, each = 5)

# Draw from the predictive distribution:
preddraws <- matrix(rnorm(length(predobj$means[,,1]),
                    mean = predobj$means[,,1],
                    sd = predobj$vols[,,1]), nrow = 4)

# Visualize the predictive distribution
pairs(t(preddraws), col = rgb(0,0,0,.1), pch = 16)
}

}
\seealso{
Other predictors: 
\code{\link{predcor}()},
\code{\link{predcov}()},
\code{\link{predh}()},
\code{\link{predloglik}()},
\code{\link{predloglikWB}()},
\code{\link{predprecWB}()}
}
\concept{predictors}
