% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_creation_functions.R
\name{draw_likert}
\alias{draw_likert}
\title{Recode a latent variable into a Likert response variable}
\usage{
draw_likert(
  x,
  min = NULL,
  max = NULL,
  bins = NULL,
  breaks = NULL,
  labels = NULL
)
}
\arguments{
\item{x}{a numeric variable considered to be "latent"}

\item{min}{the minimum value of the latent variable}

\item{max}{the maximum value of the latent variable}

\item{bins}{the number of Likert scale values. The latent variable will be cut into equally sized bins as in seq(min, max, length.out = bins + 1)}

\item{breaks}{A vector of breaks. This option is useful for settings in which equally-sized breaks are inappropriate}

\item{labels}{An optional vector of labels. If labels are provided, the resulting output will be a factor.}
}
\description{
Recode a latent variable into a Likert response variable
}
\examples{

x <- 1:100

draw_likert(x, min = 0, max = 100, bins = 7)
draw_likert(x, breaks = c(-1, 10, 100))


}
