% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_bounds.R
\name{get_gamma_bounds}
\alias{get_gamma_bounds}
\title{Bounds for the exAL shape parameter gamma}
\usage{
get_gamma_bounds(p0)
}
\arguments{
\item{p0}{Numeric scalar in (0, 1); typically the target quantile level.}
}
\value{
A numeric vector of length 2 named \code{c("L","U")}.
}
\description{
Returns valid lower/upper bounds \code{(L, U)} for the shape parameter \code{gamma}
of the standardized extended Asymmetric Laplace (exAL), given \code{p0} in (0,1).
}
\details{
This is a user-facing convenience wrapper around the C++ routine
\code{get_gamma_bounds_cpp()}, which performs the actual computation.
}
\examples{
get_gamma_bounds(0.5)
get_gamma_bounds(0.9)
}
