% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_location}
\alias{send_location}
\title{Send a location}
\usage{
send_location(
  client,
  number,
  latitude,
  longitude,
  name = NULL,
  address = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient number with country code
(e.g., \code{"5581999990000"} or \code{"+5581999990000"}).}

\item{latitude}{Numeric. Latitude coordinate.}

\item{longitude}{Numeric. Longitude coordinate.}

\item{name}{Optional character. Location label name.}

\item{address}{Optional character. Address description.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends a geographic location pin via Evolution API v2.
}
\examples{
\dontrun{
send_location(client, "5581999990000",
              latitude = -8.05, longitude = -34.88,
              name = "Recife Antigo", address = "Marco Zero")
}
}
