% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.bridge.R
\name{ergm.bridge.llr}
\alias{ergm.bridge.llr}
\alias{ergm.bridge.0.llk}
\alias{ergm.bridge.dindstart.llk}
\title{Bridge sampling to evaluate ERGM log-likelihoods and log-likelihood ratios}
\usage{
ergm.bridge.llr(
  object,
  response = NULL,
  reference = ~Bernoulli,
  constraints = ~.,
  from,
  to,
  obs.constraints = ~. - observed,
  target.stats = NULL,
  basis = ergm.getnetwork(object),
  verbose = FALSE,
  ...,
  llronly = FALSE,
  control = control.ergm.bridge()
)

ergm.bridge.0.llk(
  object,
  response = NULL,
  reference = ~Bernoulli,
  coef,
  ...,
  llkonly = TRUE,
  control = control.ergm.bridge(),
  basis = ergm.getnetwork(object)
)

ergm.bridge.dindstart.llk(
  object,
  response = NULL,
  constraints = ~.,
  coef,
  obs.constraints = ~. - observed,
  target.stats = NULL,
  dind = NULL,
  coef.dind = NULL,
  basis = ergm.getnetwork(object),
  ...,
  llkonly = TRUE,
  control = control.ergm.bridge(),
  verbose = FALSE
)
}
\arguments{
\item{object}{A model formula. See \code{\link[=ergm]{ergm()}} for details.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}

\item{reference}{{A one-sided formula specifying the reference
measure (\eqn{h(y)}) to be used.  (Defaults to
\code{~Bernoulli}.)}}

\item{constraints, obs.constraints}{One-sided formulas specifying
one or more constraints on the support of the distribution of the
networks being simulated and on the observation process
respectively. See the documentation for similar arguments for
\code{\link[=ergm]{ergm()}} for more information.}

\item{from, to}{The initial and final parameter vectors.}

\item{target.stats}{A vector of sufficient statistics to be used
in place of those of the network in the formula. \matchnames{statistic}}

\item{basis}{An optional \code{\link[network:network]{network}} object to
start the Markov chain.  If omitted, the default is the
left-hand-side of the \code{object}.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{Further arguments to \code{ergm.bridge.llr} and
\code{\link[=simulate.formula.ergm]{simulate.formula.ergm()}}.}

\item{llronly}{Logical: If TRUE, only the estiamted log-ratio will
be returned by \code{ergm.bridge.llr}.}

\item{control}{A list of control parameters for algorithm tuning,
typically constructed with \code{\link[=control.ergm.bridge]{control.ergm.bridge()}}. Its documentation
gives the the list of recognized control parameters and their
meaning. The more generic utility \code{\link[=snctrl]{snctrl()}} (StatNet ConTRoL)
also provides argument completion for the available control
functions and limited argument name checking.}

\item{coef}{A vector of coefficients for the configuration of
interest. \matchnames{coefficient}}

\item{llkonly}{Whether only the estiamted log-likelihood should be
returned by the \code{ergm.bridge.0.llk} and
\code{ergm.bridge.dindstart.llk}.  (Defaults to TRUE.)}

\item{dind}{A one-sided formula with the dyad-independent model to use as a
starting point. Defaults to the dyad-independent terms found in the formula
\code{object} with an overal density term (\code{edges}) added if not
redundant.}

\item{coef.dind}{Parameter configuration for the dyad-independent starting
point. Defaults to the MLE of \code{dind}. \matchnames{coefficient}}
}
\value{
If \code{llronly=TRUE} or \code{llkonly=TRUE}, these functions return
the scalar log-likelihood-ratio or the log-likelihood.
Otherwise, they return a list with the following components:

\item{llr}{The estimated log-ratio.}

\item{llr.vcov}{The estimated variance of the log-ratio due to
MCMC approximation.}

\item{llrs}{A list of lists (1 per attempt) of the estimated
log-ratios for each of the \code{bridge.nsteps} bridges.}

\item{llrs.vcov}{A list of lists (1 per attempt) of the estimated
variances of the estimated log-ratios for each of the
\code{bridge.nsteps} bridges.}

\item{paths}{A list of lists (1 per attempt) with two elements:
\code{theta}, a numeric matrix with \code{bridge.nsteps} rows, with each
row being the respective bridge's parameter configuration; and
\code{weight}, a vector of length \code{bridge.nsteps} containing its
weight.}

\item{Dtheta.Du}{The gradient vector of the parameter values with
respect to position of the bridge.}

\code{ergm.bridge.0.llk} result list also includes an \code{llk}
element, with the log-likelihood itself (with the reference
distribution assumed to have likelihood 0).

\code{ergm.bridge.dindstart.llk} result list also includes
an \code{llk} element, with the log-likelihood itself and an
\code{llk.dind} element, with the log-likelihood of the nearest
dyad-independent model.
}
\description{
\code{ergm.bridge.llr} uses bridge sampling with geometric spacing to
estimate the difference between the log-likelihoods of two parameter vectors
for an ERGM via repeated calls to \code{\link[=simulate.formula.ergm]{simulate.formula.ergm()}}.
\insertNoCite{HuHa06i}{ergm}

\code{ergm.bridge.0.llk} is a convenience wrapper that
returns the log-likelihood of configuration \eqn{\theta}
\emph{relative to the reference measure}. That is, the
configuration with \eqn{\theta=0} is defined as having log-likelihood of
0.

\code{ergm.bridge.dindstart.llk} is a wrapper that uses a
dyad-independent ERGM as a starting point for bridge sampling to
estimate the log-likelihood for a given dyad-dependent model and
parameter configuration.  Note that it only handles binary ERGMs
(\code{response=NULL}) and with constraints (\verb{constraints=}) that that
do not induce dyadic dependence.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=simulate.formula.ergm]{simulate.formula.ergm()}}
}
\keyword{model}
