% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.ergm.ego.R
\name{simulate.ergm.ego}
\alias{simulate.ergm.ego}
\title{Simulate from a \code{\link[=ergm.ego]{ergm.ego()}} fit.}
\usage{
\method{simulate}{ergm.ego}(
  object,
  nsim = 1,
  seed = NULL,
  constraints = object$constraints,
  popsize = if (object$popsize == 1 || object$popsize == 0 || is(object$popsize, "AsIs"))
    object$ppopsize else object$popsize,
  control = control.simulate.ergm.ego(),
  output = c("network", "stats", "edgelist", "pending_update_network", "ergm_state"),
  ...,
  basis = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{An \code{\link{ergm.ego}} fit.}

\item{nsim}{Number of realizations to simulate.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[=set.seed]{set.seed()}}.}

\item{constraints, \dots}{Additional arguments passed to \code{\link[ergm:san]{san()}} and
\code{\link[ergm:simulate.formula]{simulate.formula()}}.}

\item{popsize, basis}{A network size to which to scale the model for
simulation; a \code{\link{data.frame}} with at least those ego attributes
used to estimate the model to simulate over a specific set of
actors; or a \code{\link[network:network]{network}} object to use as is. \code{basis} is provided
for consistency with \code{\link[ergm:ergm]{ergm()}}, \code{\link[=ergm.ego]{ergm.ego()}}, \code{\link[ergm:simulate.ergm]{simulate.ergm()}},
and others. If both are specified, \code{popsize} overrules.}

\item{control}{A \code{\link[=control.simulate.ergm.ego]{control.simulate.ergm.ego()}} control list.}

\item{output}{one of \code{"network"}, \code{"stats"}, \code{"edgelist"},
\code{"pending_update_network"}, or, for future compatibility,
\code{"ergm_state"}. See help for \code{\link[ergm:simulate.ergm]{simulate.ergm()}} for explanation.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}
}
\value{
The ouput has the same format (with the same options) as
\code{\link[ergm:simulate.formula]{simulate.formula()}}. If \code{output="stats"} is passed, an
additional attribute, \code{"ppopsize"} is set, giving the actual size of
the network reconstructed, when the \code{pop.wt} control parameter is set
to \code{"round"} and \code{"popsize"} is not a multiple of the egocentric
sample size or the sampling weights.
}
\description{
A wrapper around \code{\link[ergm:simulate.formula]{simulate.formula()}} to simulate networks
from an ERGM fit using \code{\link[=ergm.ego]{ergm.ego()}}.
}
\examples{

data(faux.mesa.high)
data(fmhfit)
colMeans(egosim <- simulate(fmhfit, popsize=300,nsim=50,
                       output="stats", control=control.simulate.ergm.ego(
                       simulate=control.simulate.formula(MCMC.burnin=2e6))))
colMeans(egosim)/attr(egosim,"ppopsize")*network.size(faux.mesa.high)
summary(faux.mesa.high~edges+degree(0:3)+nodefactor("Race")+nodematch("Race")
           +nodefactor("Sex")+nodematch("Sex")+absdiff("Grade"))

}
\references{
\insertRef{KrMo2017}{ergm.ego}

\insertRef{KrMoBo2019}{ergm.ego}

\insertRef{KrHaMo2011}{ergm.ego}
}
\seealso{
\code{\link[ergm:simulate.formula]{simulate.formula()}}, \code{\link[ergm:simulate.ergm]{simulate.ergm()}}
}
\author{
Pavel N. Krivitsky
}
\keyword{models}
